module 'thread'

local paused = {}

function yield( name )
    paused[ name ] = _M.CURRENT_THREAD
    coroutine.yield( name )
end

function resume( name )
    local thread = paused[ name ]
    paused[ name ] = nil
    local errors, result = coroutine.resume( thread )
    if not errors then error( result ) end
end

return _M
